# This script starts the Outline server container ("Shadowbox").
# If you need to customize how the server is run, you can edit this script, then restart with:
#
#     "/opt/outline/persisted-state/start_container.sh"

set -eu

docker stop "outlinep-7" 2> /dev/null || true
docker rm -f "outlinep-7" 2> /dev/null || true

docker_command=(
  docker
  run
  -d
  --name "outlinep-7" --restart always 
  --network proxy-net-7 --ip 172.47.0.2
  --cap-add=NET_ADMIN
  --cap-add=NET_RAW
  --device=/dev/net/tun
  -p 37000:37000 -p 17000:17000 

  # Used by Watchtower to know which containers to monitor.
  --label 'com.centurylinklabs.watchtower.enable=true'
  --label 'com.centurylinklabs.watchtower.scope=outline'

  # Use log rotation. See https://docs.docker.com/config/containers/logging/configure/.
  --log-driver local

  # The state that is persisted across restarts.
  -v "/opt/outline7:/opt/outline"

  # Where the container keeps its persistent state.
  -e "SB_STATE_DIR=/opt/outline/persisted-state"

  # Port number and path prefix used by the server manager API.
  -e "SB_API_PORT=37000"
  -e "SB_API_PREFIX=3w7thMVWSUlYXSUs3WR9hQ"

  # Location of the API TLS certificate and key.
  -e "SB_CERTIFICATE_FILE=/opt/outline/persisted-state/shadowbox-selfsigned.crt"
  -e "SB_PRIVATE_KEY_FILE=/opt/outline/persisted-state/shadowbox-selfsigned.key"

  # Where to report metrics to, if opted-in.
  -e "SB_METRICS_URL="

  # The Outline server image to run.
  #"quay.io/outline/shadowbox:stable"
  "astroreeko/outline-proxy-1.11.0:latest"
)
"${docker_command[@]}"
